// ------------------------------------
//    OnBoardC Library master header
//            Version 1.07
//    by: Harry Konstas Sep 9/2000
// ------------------------------------
 
// Talt 
#define DebugAlert 1000
#define ErrorAlert 1100
#define AboutAlert 1200
#define MsgAlert 1300

// Hard keys
#define keyBitPageUp   0x02
#define keyBitPageDown 0x04
#define keyBitHard1	   0x08
#define keyBitHard2	   0x10
#define keyBitHard3	   0x20
#define keyBitHard4	   0x40
#define keyBitCradle   0x80

// ------------------------------------ 
//        STRUCTURES & GLOBALS
// ------------------------------------

typedef struct {
  int compressed;
  int spare;
  ULong DocSize;
  UInt rNum;
  UInt rSize;
  ULong position;
  int spare2;      // SmartDoc
}DOCHEADER;

typedef struct {
  DOCHEADER *pHeader;
  DmOpenRef db;
  int iRec;
  int nRecs;
  ULong RecSize;
  Handle hFile;
  CharPtr pData;
  VoidHand hBuff;
  int iBuff;
  char *buffer;
}DOCFILE;

typedef struct {
  DmOpenRef db;
  int iRec;
  int nRecs;
  ULong RecSize;
  ULong RecPos;
  Handle h;
  CharPtr pData;
  char buffer[100];
}MEMODB;

typedef struct {
  DmOpenRef db;
  Handle hFont;
}FONTFILE;

typedef struct {
  int x;
  int y;
  int w;
  int h;
  int hgt;
  int wdt;
  int colstart;
  int colend;
  int rowstart;
  int rowend;
  int curcol;
  int currow;
  RectanglePtr sRec;
  RectanglePtr dRec;
  RectanglePtr cRec;
  RectanglePtr eRec;
  char history[80];
}STDOUT;

// ------------------------------------ 
//       STANDARD API PROTOTYPES
// ------------------------------------

// Misc 
void AbtShowAbout(DWord creator) SYS_TRAP(sysTrapAbtShowAbout);							 
void ErrDisplayFileLineMsg(CharPtr filename, UInt lineno, CharPtr msg) SYS_TRAP(sysTrapErrDisplayFileLineMsg);
void FldInsert(FieldPtr fld, CharPtr s,Word len) SYS_TRAP(sysTrapFldInsert);
void RctSetRectangle(RectanglePtr r,SWord left,SWord top,SWord width,SWord height) SYS_TRAP(sysTrapRctSetRectangle);
Err FntDefineFont(FontID fontID, FontPtr fontP) SYS_TRAP(sysTrapFntDefineFont);
void InsPtEnable(Boolean enable) SYS_TRAP(sysTrapInsPtEnable);
void CtlHitControl(ControlPtr c) SYS_TRAP(sysTrapCtlHitControl);
Err ScrDisplayMode(int op,DWord *w,DWord *h, DWord *d, int *color) SYS_TRAP(sysTrapScrDisplayMode);

void LstMakeItemVisible(ListPtr ListP,Word item) SYS_TRAP(sysTrapLstMakeItemVisible);
void LstDrawList(ListPtr list) SYS_TRAP(sysTrapLstDrawList);
//DWord KeyCurrentState(void) SYS_TRAP(sysTrapKeyCurrentState);
Boolean LstScrollList(ListPtr pList,enum directions dir,short count) SYS_TRAP(sysTrapLstScrollList);

void WinDrawChar(UInt c, UInt x, UInt y) SYS_TRAP(sysTrapWinDrawChar);
void InsPtSetLocation(int x, int y) SYS_TRAP(sysTrapInsPtSetLocation);
void InsPtSetHeight(int h) SYS_TRAP(sysTrapInsPtSetHeight);

// Form
//void FrmPopupForm(Word formId) SYS_TRAP(sysTrapFrmPopupForm);
void FrmHideObject(FormPtr frm, Word objIndex) SYS_TRAP(sysTrapFrmHideObject);
void FrmShowObject(FormPtr frm, Word objIndex) SYS_TRAP(sysTrapFrmShowObject);
void FrmSetTitle(FormPtr frm, CharPtr newTitle) SYS_TRAP(sysTrapFrmSetTitle);
void FrmUpdateForm(Word formId, Word updateCode) SYS_TRAP(sysTrapFrmUpdateForm);
Word FrmGetFormId(FormPtr frm) SYS_TRAP(sysTrapFrmGetFormId);
//void FrmSetControlValue(FormPtr frm, UInt objindex, int value) SYS_TRAP(sysTrapFrmSetControlValue);

// Event
Boolean EvtSysEventAvail(Boolean ignorePenUps) SYS_TRAP(sysTrapEvtSysEventAvail);
//void EvtAddEventToQueue(EventPtr event) SYS_TRAP(sysTrapEvtAddEventToQueue);
Err EvtFlushPenQueue(void) SYS_TRAP(sysTrapEvtFlushPenQueue);
Err EvtFlushKeyQueue(void) SYS_TRAP(sysTrapEvtFlushKeyQueue);
void EvtEnableGraffiti(Boolean enable) SYS_TRAP(sysTrapEvtEnableGraffiti);
Err EvtResetAutoOffTimer(void) SYS_TRAP(sysTrapEvtResetAutoOffTimer);

// Window
void WinDrawGrayRectangleFrame (int frame, RectanglePtr r) SYS_TRAP(sysTrapWinDrawGrayRectangleFrame); 
//void WinSetPattern (CustomPatternType Type) SYS_TRAP(sysTrapWinSetPattern); 
void WinEraseWindow(void) SYS_TRAP(sysTrapWinEraseWindow);	
//void WinInvertRectangleFrame(int frame, RectanglePtr r) SYS_TRAP(sysTrapWinInvertRectangleFrame);
void WinEraseRectangleFrame (int frame, RectanglePtr r) SYS_TRAP(sysTrapWinEraseRectangleFrame); 
void WinEnableWindow(WinHandle winHandle) SYS_TRAP(sysTrapWinEnableWindow);
void WinInitializeWindow(WinHandle winHandle) SYS_TRAP(sysTrapWinInitializeWindow);
//WinHandle WinGetActiveWindow(void) SYS_TRAP(sysTrapWinGetActiveWindow);
void WinDisableWindow(WinHandle winHandle) SYS_TRAP(sysTrapWinDisableWindow);
void WinGetWindowExtent(SWord *extentX, SWord *extentY) SYS_TRAP(sysTrapWinGetWindowExtent);
void WinSetActiveWindow(WinHandle winHandle) SYS_TRAP(sysTrapWinSetActiveWindow);

// System
VoidHand SysFormPointerArrayToStrings(CharPtr c,int count) SYS_TRAP(sysTrapSysFormPointerArrayToStrings);
void SysAppLauncherDialog() SYS_TRAP(sysTrapSysAppLauncherDialog);
CharPtr SysStringByIndex(Word resID, Word index, CharPtr strP, Word maxLen) SYS_TRAP(sysTrapSysStringByIndex);
Word SysTicksPerSecond(void) SYS_TRAP(sysTrapSysTicksPerSecond);
Err SysUIAppSwitch (UInt cardNo, LocalID dbID, Word cmd, Ptr cmdPBP) 
    SYS_TRAP(sysTrapSysUIAppSwitch);
 
// Mem/Database
Err DmDeleteRecord(DmOpenRef dbP, UInt index) SYS_TRAP(sysTrapDmDeleteRecord);
Err MemPtrResize(VoidPtr p,ULong newSize) SYS_TRAP(sysTrapMemPtrResize);
Err DmWriteCheck(VoidPtr p,ULong offset, ULong bytes) SYS_TRAP(sysTrapDmWriteCheck);
Err DmOpenDatabaseInfo(DmOpenRef dbP, LocalID* dbIDP, UIntPtr openCountP, UIntPtr modeP, UIntPtr cardNoP, Boolean *resDBP)
      SYS_TRAP(sysTrapDmOpenDatabaseInfo);

// Serial comm. API functions
Err SerOpen(UInt refNum, UInt port, ULong baud) SYS_TRAP(sysLibTrapOpen); 
Err SerClose(UInt refNum) SYS_TRAP(sysLibTrapClose); 
Err SerSend10(UInt refNum, VoidPtr bufP, ULong size) SYS_TRAP(sysLibTrapCustom+4); 
Err SerReceive10(UInt refNum, VoidPtr bufP, ULong bytes, Long timeout) SYS_TRAP(sysLibTrapCustom+8); 
Err SerSleep(UInt refNum) SYS_TRAP(sysLibTrapSleep); 
Err SerWake(UInt refNum) SYS_TRAP(sysLibTrapWake); 
Err SerSendFlush(UInt refNum) SYS_TRAP(sysLibTrapCustom+7); 
Err SerReceiveCheck(UInt refNum, ULongPtr numBytesP) SYS_TRAP(sysLibTrapCustom+10); 
Err SerSetReceiveBuffer(UInt refNum, VoidPtr bufP, UInt bufSize) SYS_TRAP(sysLibTrapCustom+12); 	
Err SerSendWait(UInt refNum, Long timeout) SYS_TRAP(sysLibTrapCustom+5); 
void SerReceiveFlush(UInt refNum, Long timeout) SYS_TRAP(sysLibTrapCustom+11); 


// ------------------------------------ 
//        HK LIBRARY PROTOTYPES
// ------------------------------------

// DOC functions
DOCFILE *NewDoc(CharPtr fname);
DOCFILE *OpenDoc(CharPtr fname);
void RewindDoc(DOCFILE *pDoc);
int ReadDocLine(DOCFILE *pDoc);
int WriteDoc(DOCFILE *pDoc, CharPtr text);
int docprintf(DOCFILE *pDoc, const Char* formatStr, ...);
void CloseDoc(DOCFILE *pDoc);

// MEMO R/W functions
MEMODB *OpenMemo(void);
void CloseMemo(MEMODB *pMemo);
void NewMemo(MEMODB *pMemo, ULong size);
int WriteMemo(MEMODB *pMemo, CharPtr text);
int SelectMemo(MEMODB *pMemo, UInt memonum);
int ReadMemoLine(MEMODB *pMemo);
MEMODB *FindMemo(char *memoname);
UInt MakeMemoList(UInt ListID,char *mask);
void DiscardMemoList(void);

// Database functions
void DeleteDB(char *name);
DmOpenRef NewDB(char *fname,ULong creator,ULong type);
DmOpenRef OpenDB(char *fname);
int RenameDB(char *oldname, char *newname);
void CloseDB(DmOpenRef db);

// File Listbox functions
UInt MakeFileList(UInt ListID,ULong creator, ULong type, CharPtr mask);
UInt MakeStrList(UInt ListID, UInt strID);
char *GetListItem(UInt ListID);
void DiscardFileList(void);

// Misc utilities
void AppSwitch(char *fname);
char *StripLF(char *s);
void DelaySec(Word secs);
char *UpperCase(char *s);
UInt HexToI(char *hexstr);
void ByteToHex(Byte v, char *buffer);
int  IsAlpha(char c);
int  FindChar(char *s, char c);
void AddStr(char *d, char *s);
char *RevStr(char *s);
int  GetSysString(Word strID, Word index, char *string);
void WaitTap(void);
int  DrawBitmap(UInt id, int x, int y);
int  GetBitmapSize(UInt id, int *w, int *h);

// Float functions
char *LongToA(long value, char *string);
float AtoFloat(char *s);
char *FloatToA(float f, char *buf);
float AbsFloat(float x);

// Error/msg boxes
int UserAbort(void);
void DebugWin(CharPtr varname, long value);
void ErrorBox(CharPtr msg,CharPtr cause);
void MsgBox(CharPtr msg1,CharPtr msg2);
void Output(Word FieldID, CharPtr message);
int  AskBox(int AltForm,CharPtr msg);

// Object control
void HideControl(Word objID);
void ShowControl(Word objID);
void SetControlState(Word objID, int state);
VoidPtr GetObjectPtr(Word objectID);
static void SetTextToObject(Word objID, CharPtr text);
CharPtr GetTextFromObject(Word objID);

// Serial port
UInt SerEnable(ULong baud);
void sersend(UInt ref,Byte data);
int serrecv(UInt ref);
int anydata(UInt ref);
void SerSendStr(UInt port, char *s);
void EnableInfrared(void);
void DisableInfrared(void);

// Fonts
FONTFILE *LoadFont(CharPtr fname, int fID);
void DiscardFont(FONTFILE *pFont);

// Stdout
STDOUT *OpenStdout(int x, int y, int w, int h);
void WriteStdout(STDOUT *pOut, CharPtr string);
void PrintStdout(STDOUT *pOut, char *s);
void PutStdout(STDOUT *pOut, char c);
char *GetStdin(STDOUT *pOut,char *buffer);
int  GetStdKey(void);
void ClearStdout(STDOUT *pOut);
void CloseStdout(STDOUT *pOut);
